<?php
/*
$GLOBALS['_SubjectTxt_STORAGE'] = 'apc';      // vAPC
$GLOBALS['_SubjectTxt_STORAGE'] = 'eaccelerator';    // veAccelerator

[dl] eaccelerator, apc ƒLbVȂ
[dl] eaccelerator, apc modifiedȂ

eaccelerator, apc ɂĂptH[}X͂ĕςȂ悤
*/
class SubjectTxt
{
    var $host;
    var $bbs;
    var $subject_url;  // @access private
    var $subject_file; // @access private
    var $subject_lines; // @access public
    
    // 2006/02/27 aki eaccelerator, apc ͔񐄏
    var $storage; // file, eaccelerator(eAccelerator shm), apc
    
    /**
     * @constructor
     */
    function SubjectTxt(&$host, $bbs)
    {
        $this->initProperties($host, $bbs);
        
        // subject.txt_E[hZbg
        $this->dlAndSetSubject();
        
        // downloadSubject()̃zXgړ]mɏꂽVhost𔽉f
        $host = $this->host;
    }
    
    /**
     * @access  private
     * @return  void
     */
    function initProperties($host, $bbs)
    {
        $this->host = $host;
        $this->bbs =  $bbs;
        
        if (isset($GLOBALS['_SubjectTxt_STORAGE'])) {
            if (in_array($GLOBALS['_SubjectTxt_STORAGE'], array('eaccelerator', 'apc'))) {
                $this->storage = $GLOBALS['_SubjectTxt_STORAGE'];
            }
        }
        if (!isset($this->storage)) {
            $this->storage = 'file';
        }
        
        $this->subject_file = $this->getSubjectFile($this->host, $this->bbs);
        $this->subject_url = $this->getSubjectUrl($this->host, $this->bbs);
    }
    
    /**
     * @access  private
     * @return  string
     */
    function getSubjectFile($host, $bbs)
    {
        return P2Util::datDirOfHostBbs($host, $bbs) . 'subject.txt';
    }
    
    /**
     * @access  private
     * @return  string
     */
    function getSubjectUrl($host, $bbs)
    {
        //$subject_url = 'http://' . $host . '/' . $bbs . '/subject.txt';
        $subject_url = sprintf(
            'http://%s/%s%s/subject.txt',
            $host,
            P2Util::isHostCha2($host) ? 'cgi-bin/' : '',
            $bbs
        );
        
        // ΂̃hCύXɑΉBǍ΂ƂB
        return $subject_url = P2Util::adjustHostJbbsShitaraba($subject_url);
    }
    
    /**
     * subject.txt_E[hZbg
     *
     * @access  private
     * @return  boolean  Zbgł true
     */
    function dlAndSetSubject()
    {
        $lines = array();
        if ($this->storage == 'eaccelerator') {
            $lines = eaccelerator_get("$this->host/$this->bbs");
        } elseif ($this->storage == 'apc') {
            $lines = apc_fetch("$this->host/$this->bbs");
        }
        
        if (!$lines || !empty($_POST['newthread'])) {
            $lines = $this->downloadSubject();
        }
        
        return $this->loadSubjectLines($lines) ? true : false;
    }

    /**
     * subject.txt_E[h
     *
     * @access  public
     * @return  array|null|false  subject.txt̔zf[^(eaccelerator, apcp)A܂nullԂB
     *                            sꍇfalseԂB
     */
    function downloadSubject()
    {
        global $_conf;

        static $spentDlTime_ = 0; // DLvv
        
        $perm = isset($_conf['dl_perm']) ? $_conf['dl_perm'] : 0606;

        $modified = false;
        
        if ($this->storage == 'file') {
            if (false === FileCtl::mkdirFor($this->subject_file)) {
                return false;
            }
            if (file_exists($this->subject_file)) {
            
                // t@CLbV΁ADLԂ
                if (UA::isK()) {
                    $dlSubjectTotalLimitTime = $_conf['dlSubjectTotalLimitTimeM'];
                } else {
                    $dlSubjectTotalLimitTime = $_conf['dlSubjectTotalLimitTime'];
                }
                if ($dlSubjectTotalLimitTime and $spentDlTime_ > $dlSubjectTotalLimitTime) {
                    return null;
                }
                
                // ɂāALbVKp
                // subject.php refreshw肪鎞́ALbVKpȂ
                if (!(basename($_SERVER['SCRIPT_NAME']) == $_conf['subject_php'] && !empty($_REQUEST['refresh']))) {
                    
                    // LbVKpw莞́ȀŔ
                    if (!empty($_GET['norefresh']) || isset($_REQUEST['word'])) {
                        return null;
                        
                    // _E[hς̏ꍇ
                    } elseif (!empty($GLOBALS['expack.subject.multi-threaded-download.done'])) {
                        return null;
                    
                    // VKXĎȊOŁALbVVNȏꍇ
                    } elseif (empty($_POST['newthread']) and $this->isSubjectTxtFresh()) {
                        return null;
                    }
                }
                
                $modified = gmdate("D, d M Y H:i:s", filemtime($this->subject_file)) . " GMT";
            
            }
        }

        $dlStartTime = $this->microtimeFloat();
        
        // DL
        require_once 'HTTP/Request.php';
        
        $params = array();
        $params['timeout'] = $_conf['fsockopen_timeout'];
        if ($_conf['proxy_use']) {
            $params['proxy_host'] = $_conf['proxy_host'];
            $params['proxy_port'] = $_conf['proxy_port'];
        }
        $req = new HTTP_Request($this->subject_url, $params);
        $modified && $req->addHeader('If-Modified-Since', $modified);
        $req->addHeader('User-Agent', sprintf('Monazilla/1.00 (%s/%s)', $_conf['p2uaname'], $_conf['p2version']));
        
        $response = $req->sendRequest();
        
        $error_msg = null;
        if (PEAR::isError($response)) {
            $error_msg = $response->getMessage();
        } else {
            $code = $req->getResponseCode();
            // 302 Found (Redirection ])
            // 2010/08/05 uƐl吙 vł302ԂƂɒӁiLocation: http://www2.2ch.net/live.htmlj
            // 301 Moved Permanently
            if (P2Util::isHost2chs($this->host) and in_array($code, array(302, 301))) { // scΉ̂2chɍi
                // zXg̈ړ]ǐ
                require_once P2_LIB_DIR . '/BbsMap.php';
                require_once P2_LIB_DIR . '/SettingTxt.php';
                $new_host = null;
                if ($location = $req->getResponseHeader('Location')) {
                    if (preg_match('{https?://(.+?)/[^/]+/subject\\.txt$}', $location, $m)) {
                        $new_host = $m[1];
                    }
                }
                if (!$new_host) {
                    $new_host = BbsMap::getCurrentHost($this->host, $this->bbs);
                }
                if (
                    $new_host != $this->host
                    // SETTING.TXT̗LŔړ]mF
                    and SettingTxt::check2chHostMovedBySettingTxt($new_host, $this->host, $this->bbs)
                ) {
                    BbsMap::syncHost($new_host, $this->bbs, $this->host);
                    $this->initProperties($new_host, $this->bbs);
                    return $this->downloadSubject();
                }
            }
            if (!in_array($code, array(200, 206, 304))) {
                //var_dump($req->getResponseHeader());
                $error_msg = $code;
            }
        }
    
        if (!is_null($error_msg) && strlen($error_msg)) {
            $attrs = array();
            if ($_conf['ext_win_target']) {
                $attrs['target'] = $_conf['ext_win_target'];
            }
            $atag = P2View::tagA(
                P2Util::throughIme($this->subject_url),
                hs($this->subject_url),
                $attrs
            );
            $msg_ht = sprintf(
                '<div>Error: %s<br>p2 info - %s ɐڑł܂łB</div>',
                hs($error_msg),
                $atag
            );
            P2Util::pushInfoHtml($msg_ht);
            $body = '';
        } else {
            $body = $req->getResponseBody();
        }

        $dlEndTime = $this->microtimeFloat();
        $dlTime = $dlEndTime - $dlStartTime;
        $spentDlTime_ += $dlTime;

        // DL  XVĂ
        if ($body && $code != '304') {

            //  or be.2ch.net ȂEUCSJISɕϊ
            if (P2Util::isHostJbbsShitaraba($this->host) || P2Util::isHostBe2chNet($this->host)) {
                $body = mb_convert_encoding($body, 'SJIS-win', 'eucJP-win');
            }
            
            // eaccelerator or apcɕۑꍇ
            if ($this->storage == 'eaccelerator' || $this->storage == 'apc') {
                $cache_key = "$this->host/$this->bbs";
                $cont = rtrim($body);
                $lines = explode("\n", $cont);
                if ($this->storage == 'eaccelerator') {
                    eaccelerator_lock($cache_key); 
                    eaccelerator_put($cache_key, $lines, $_conf['sb_dl_interval']);
                    eaccelerator_unlock($cache_key);
                } else {
                    apc_store($cache_key, $lines, $_conf['sb_dl_interval']);
                }
                return $lines;
            
            
            // t@Cɕۑꍇ
            } else {
                if (false === FileCtl::filePutRename($this->subject_file, $body)) {
                    // ۑɎs͂ĂÃLbVǂݍ߂Ȃ悵ƂĂ
                    if (is_readable($this->subject_file)) {
                        return null;
                    } else {
                        die("Error: cannot write file");
                        return false;
                    }
                }
                chmod($this->subject_file, $perm);
            }
            
        } else {
            // touch邱ƂōXVC^[ôŁA΂炭ă`FbNȂȂ
            // iύXȂ̂ɏCԂXV̂́ACi܂ȂAł͓ɖȂ낤j
            if ($this->storage == 'file') {
                touch($this->subject_file);
            }
        }
        
        return null;
    }
    
    
    /**
     * subject.txt VNȂ true Ԃ
     *
     * @access  private
     * @return  boolean  VNȂ trueBłȂ falseB
     */
    function isSubjectTxtFresh()
    {
        global $_conf;

        if (file_exists($this->subject_file)) {
            // LbV̍XVw莞ԈȓȂ
            // clearstatcache();
            if (filemtime($this->subject_file) > time() - $_conf['sb_dl_interval']) {
                return true;
            }
        }
        
        return false;
    }

    /**
     * subject.txt ǂݍ݁AZbgA
     * ΁A$this->subject_lines Zbg
     *
     * @access  private
     * @param   string   $lines    eaccelerator, apcp
     * @return  boolean  s
     */
    function loadSubjectLines($lines = null)
    {
        if (!$lines) {
            if ($this->storage == 'eaccelerator') {
                $this->subject_lines = eaccelerator_get("$this->host/$this->bbs");
            } elseif ($this->storage == 'apc') {
                $this->subject_lines = apc_fetch("$this->host/$this->bbs");
            } elseif ($this->storage == 'file') {
                $this->subject_lines = file($this->subject_file);
            } else {
                return false;
            }
        } else {
            $this->subject_lines = $lines;
        }
        
        // JBBS@΂ȂdX^C폜
        if (P2Util::isHostJbbsShitaraba($this->host)) {
            $this->subject_lines = array_unique($this->subject_lines);
        }
        
        return $this->subject_lines ? true : false;
    }

    /**
     * PHP 5microtime͋[ȒPȃ\bh
     *
     * @access  private
     * @return  float
     */
    function microtimeFloat()
    {
       list($usec, $sec) = explode(' ', microtime());
       return ((float)$usec + (float)$sec);
    }
}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
