<?php
require_once P2_LIB_DIR . '/BrdMenu.php';

/**
 * p2 - XgRg[NX for menu.php
 * static\bhŗpĂ
 *
 * BrdUtil ɉC
 */
class BrdCtl
{
    /**
     * Cɓǂݍ
     *
     * @static
     * @access  public
     * @return  array
     */
    function readFavItas()
    {
        global $_conf;
        
        // favitaǂݍ
        $favitas = array();
        if (file_exists($_conf['favita_path'])) {
            if ($lines = file($_conf['favita_path'])) {
                foreach ($lines as $l) {
                    if (preg_match("/^\t?(.+)\t(.+)\t(.+)\$/", trim($l), $matches)) {
                        $favitas[] = array(
                            'host' => $matches[1],
                            'bbs'  => $matches[2],
                            'itaj' => $matches[3],
                        );
                    }
                }
            }
        }
        return $favitas;
    }
    
    /**
     * boardSēǂݍ
     *
     * @static
     * @access  public
     * @return  array
     */
    function readBrdMenus()
    {
        return array_merge(BrdCtl::readBrdLocal(), BrdCtl::readBrdOnline());
    }
    
    /**
     * [JboardfBNg𑖍ēǂݍ
     *
     * @static
     * @access  private
     * @return  array
     */
    function readBrdLocal()
    {
        $brd_menus = array();
        $brd_dir = './board';
        
        if (is_dir($brd_dir) and $cdir = dir($brd_dir)) {
            while ($entry = $cdir->read()) {
                if (preg_match('/^\./', $entry)) {
                    continue;
                }
                $filepath = $brd_dir . '/' . $entry;
                if ($data = file($filepath)) {
                    $aBrdMenu = new BrdMenu;
                    $aBrdMenu->setBrdMatch($filepath);    // p^[}b``o^
                    $aBrdMenu->setBrdList($data);    // JeS[ƔZbg
                    $brd_menus[] = $aBrdMenu;
                    
                } else {
                    P2Util::pushInfoHtml(
                        sprintf("<p>p2 error: Xg %s ǂݍ߂܂łB</p>\n", $entry)
                    );
                }
            }
            $cdir->close();
        }
        
        return $brd_menus;
    }
    
    /**
     * @access  public
     * @return  string
     */
    function getP2BrdFile($cachefile)
    {
        return $cachefile . '.p2.brd';
    }
    
    /**
     * ICXgǂݍ
     *
     * @static
     * @access  private
     * @return  array
     */
    function readBrdOnline()
    {
        global $_conf;

        if (!$_conf['brdfile_online']) {
            return array();
        }
        
        $brd_menus = array();

        $cachefile = P2Util::cacheFileForDL($_conf['brdfile_online']);
        $noDL = false;
        $isNewDL = false;
        $read_html_flag = false;
        
        $p2brdfile = BrdCtl::getP2BrdFile($cachefile);
        
        // LbVꍇ
        if (file_exists($p2brdfile)) {
        
            // norefreshȂDLȂ
            if (!empty($_GET['nr'])) {
                $noDL = true;
                
            // LbV̍XVw莞ԈȓȂDLȂ
            } elseif (filemtime($p2brdfile) > time() - 60 * 60 * $_conf['menu_dl_interval']) {
                $noDL = true;
            }
        }
        
        // DLȂ
        if ($noDL) {
            ;
        // DL
        } else {
            //echo "DL!<br>";//
            $brdfile_online_res = P2Util::fileDownload(
                $_conf['brdfile_online'], $cachefile,
                array('disp_error' => true, 'use_tmp_file' => true)
            );
            if ($brdfile_online_res and $brdfile_online_res->is_success() && $brdfile_online_res->code != '304') {
                $isNewDL = true;
            }
        }
        
        // html`Ȃ
        if (preg_match('/\\.html?$/', $_conf['brdfile_online'])) {
        
            // XVĂVKLbV쐬
            if ($isNewDL) {

                //echo "NEW!<br>"; //
                $aBrdMenu = new BrdMenu;
                $aBrdMenu->makeBrdFile($cachefile); // .p2.brdt@C𐶐
                $brd_menus[] = $aBrdMenu;

                $read_html_flag = true;
            }
            
            if (file_exists($p2brdfile)) {
                $cache_brd = $p2brdfile;
            } else {
                $cache_brd = $cachefile;
            }
        
        // brdt@C
        } else {
            $cache_brd = $cachefile;
        }
        
        if (!$read_html_flag) {
            if ($data = file($cache_brd)) {
                $aBrdMenu = new BrdMenu;
                $aBrdMenu->setBrdMatch($cache_brd); // p^[}b``o^
                $aBrdMenu->setBrdList($data);       // JeS[ƔZbg
                if ($aBrdMenu->num) {
                    $brd_menus[] = $aBrdMenu;
                } else {
                    P2Util::pushInfoHtml(
                        sprintf(
                            "<p>p2 error: %s j[𐶐邱Ƃ͂ł܂łB</p>\n",
                            hs($cache_brd)
                        )
                    );
                }
            } else {
                P2Util::pushInfoHtml(sprintf("<p>p2 error: %s ͓ǂݍ߂܂łB</p>\n", hs($cachefile)));
            }
        }
        
        return $brd_menus;
    }
    
    /**
     * iX^CjwordNG[΃p[X
     * $GLOBALS['word'], $GLOBALS['words_fm'], $GLOBALS['word_fm'] Zbg
     *
     * @static
     * @access  public
     * @return  void
     */
    function parseWord()
    {
        $GLOBALS['word'] = null;
        $GLOBALS['words_fm'] = null;
        $GLOBALS['word_fm'] = null;
        
        if (isset($_GET['word'])) {
            $word = $_GET['word'];
        } elseif (isset($_POST['word'])) {
            $word = $_POST['word'];
        }

        if (!isset($word) || strlen($word) == 0) {
            return;
        }
        
        /*
        // ʂɏO
        // ł}b`Ă܂K\
        if (preg_match('/^\.+$/', $word)) {
            return;
        }
        */
        
        require_once P2_LIB_DIR . '/StrCtl.php';
        // andł낵iK\ł͂Ȃj
        $word_fm = StrCtl::wordForMatch($word, 'and');
        if (P2_MBREGEX_AVAILABLE == 1) {
            $GLOBALS['words_fm'] = mb_split('\s+', $word_fm);
            $GLOBALS['word_fm'] = mb_ereg_replace('\s+', '|', $word_fm);
        } else {
            $GLOBALS['words_fm'] = preg_split('/\s+/', $word_fm);
            $GLOBALS['word_fm'] = preg_replace('/\s+/', '|', $word_fm);
        }
    
        $GLOBALS['word'] = $word;
    }
    
    /**
     * gїp iX^Cj̃tH[HTML擾
     *
     * @static
     * @access  public
     * @return  void
     */
    function getMenuKSearchFormHtml($action = null)
    {
        global $_conf;
        
        is_null($action) and $action = $_SERVER['SCRIPT_NAME'];
        
        $threti_ht = ''; // X^C͖Ή
    
        $word_hs = isset($GLOBALS['word']) ? hs($GLOBALS['word']) : null;
    
        return <<<EOFORM
<form class="itaKensaku" method="GET" action="{$action}" accept-charset="{$_conf['accept_charset']}">
    <input type="hidden" name="detect_hint" value="">
    {$_conf['k_input_ht']}
    <input type="hidden" name="nr" value="1">
    <input type="text" id="word" name="word" value="{$word_hs}" size="12">
    {$threti_ht}
    <input type="submit" name="submit" value="">
</form>\n
EOFORM;
    }
}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
