<?php
// {{{ SettingTxt

/**
 * p2 - 2ch  SETTING.TXT NX
 * http://news19.2ch.net/newsplus/SETTING.TXT
 *
 * @created  2006/02/27
 */
class SettingTxt
{
    // {{{ properties
    
    // @access  public
    var $setting_array = array(); // SETTING.TXTp[XAzz
    
    /**#@+
     * @access  private
     */
    var $host;
    var $bbs;
    var $url;           // SETTING.TXT URL
    var $setting_txt;   // SETTING.TXT [Jۑt@CpX
    
    // p2_kb_setting.srd $this->setting_array  serialize() LbVf[^t@CpX
    var $setting_srd;

    var $cache_interval;
    /**#@-*/

    // }}}
    
    /**
     * @constructor
     */
    function SettingTxt($host, $bbs)
    {
        $this->cache_interval = 60 * 60 * 12; // LbV12ԗL
        
        $this->host = $host;
        $this->bbs =  $bbs;
        
        $dat_bbs_dir_s = P2Util::datDirOfHostBbs($this->host, $this->bbs);
        $this->setting_txt = $dat_bbs_dir_s . 'SETTING.TXT';
        $this->setting_srd = $dat_bbs_dir_s . 'p2_kb_setting.srd';
        
        $this->url = 'http://' . $this->host . '/' . $this->bbs . '/SETTING.TXT';
        
        // ΂̃hCύXɑΉBǍ΂ƂB
        //$this->url = P2Util::adjustHostJbbsShitaraba($this->url);
        
        // SETTING.TXT _E[hZbg
        $this->dlAndSetData();
    }

    /**
     * SETTING.TXT _E[hZbg
     *
     * @access  private
     * @return  void
     */
    function dlAndSetData()
    {
        $this->downloadSettingTxt();

        $this->setting_array = $this->readSettingArrayFromSettingSrd();
    }

    /**
     * SETTING.TXT _E[hāAp[XāALbV
     *
     * @access  public
     * @return  true|null|false  |XVȂiLbVj|s
     */
    function downloadSettingTxt()
    {
        global $_conf;

        $perm = $_conf['dl_perm'] ? $_conf['dl_perm'] : 0606;

        if (false === FileCtl::mkdirFor($this->setting_txt)) {
            return false;
        }
        
        $modified = null;
        if (file_exists($this->setting_srd) && file_exists($this->setting_txt)) {
        
            // XVȂꍇ́ȀŔĂ܂
            if (!empty($_GET['norefresh']) || isset($_REQUEST['word'])) {
                return null;
                
            // LbVVꍇ
            } elseif ($this->isSettingSrdCacheFresh()) {
                return null;
            }
            
            $modified = gmdate('D, d M Y H:i:s', filemtime($this->setting_txt)) . ' GMT';
        }

        // DL
        /*
        // PHP5
        if (!class_exists('HTTP_Request', false)) {
            require 'HTTP/Request.php';
        }
        */
        require_once 'HTTP/Request.php';
        
        $params = array();
        $params['timeout'] = $_conf['fsockopen_timeout'];
        if ($_conf['proxy_use']) {
            $params['proxy_host'] = $_conf['proxy_host'];
            $params['proxy_port'] = $_conf['proxy_port'];
        }
        $req = new HTTP_Request($this->url, $params);
        $modified && $req->addHeader('If-Modified-Since', $modified);
        $req->addHeader('User-Agent', 'Monazilla/1.00 (' . $_conf['p2uaname'] . '/' . $_conf['p2version'] . ')');
        
        $response = $req->sendRequest();

        $error_msg = null;
        if (PEAR::isError($response)) {
            $error_msg = $response->getMessage();
        } else {
            $code = $req->getResponseCode();

            /*
            // SETTING.TXT ݂Ăꍇ́Aړ]͂ĂȂƔf
            if ($code == 302) {
                // zXg̈ړ]ǐ
                require_once P2_LIB_DIR . '/BbsMap.php';
                $new_host = BbsMap::getCurrentHost($this->host, $this->bbs);
                if ($new_host != $this->host) {
                    $aNewSettingTxt = new SettingTxt($new_host, $this->bbs);
                    return $aNewSettingTxt->downloadSettingTxt();
                }
            }
            */
            
            if (!($code == 200 || $code == 206 || $code == 304)) {
                //var_dump($req->getResponseHeader());
                $error_msg = $code;
            }
        }

        // DLG[
        if (strlen($error_msg)) {
            P2Util::pushInfoHtml(
                sprintf(
                    '<div>Error: %s<br>p2 info - %s ɐڑł܂łB</div>',
                    hs($error_msg),
                    P2View::tagA(
                        P2Util::throughIme($this->url),
                        hs($this->url),
                        array('target' => $_conf['ext_win_target'])
                    )
                )
            );
            touch($this->setting_txt); // DLsꍇ(404) touch 
            touch($this->setting_srd);
            return false;
        }

        $body = $req->getResponseBody();

        // DL  XVĂۑ
        if ($body && $code != 304) {

            //  or be.2ch.net ȂEUCSJISɕϊ
            if (P2Util::isHostJbbsShitaraba($this->host) || P2Util::isHostBe2chNet($this->host)) {
                $body = mb_convert_encoding($body, 'SJIS-win', 'eucJP-win');
            }
            
            if (false === FileCtl::filePutRename($this->setting_txt, $body)) {
                die('Error: cannot write file');
            }
            chmod($this->setting_txt, $perm);
            
            // p[X
            if (!$this->setSettingArrayFromSettingTxt()) {
                return false;
            }
            // srdۑ
            if (!$this->saveSettingSrd($this->setting_array)) {
                return false;
            }
            
        } else {
            // touch邱ƂōXVC^[ôŁA΂炭ă`FbNȂȂ
            touch($this->setting_txt);
            // ɃLbVtouchȂƁAsetting_txtsetting_srdōXVԂāA
            // 񂱂܂ŏiT[oւ̃wb_NGXgԁjꍇB
            touch($this->setting_srd);
        }

        return true;
    }
    
    
    /**
     * LbVVNȂ true Ԃ
     *
     * @acccess  private
     * @return   boolean
     */
    function isSettingSrdCacheFresh()
    {
        if (file_exists($this->setting_srd)) {
            // LbV̍XVw莞ԈȓȂ
            // clearstatcache();
            if (filemtime($this->setting_srd) > time() - $this->cache_interval) {
                return true;
            }
        }

        return false;
    }
    
    /**
     * SETTING.TXT p[XăLbVۑ
     *
     * ΁A$this->setting_array Zbg
     *
     * @acccess  private
     * @return   boolean  s
     */
    function setSettingArrayFromSettingTxt()
    {
        global $_conf;

        $this->setting_array = array();

        if (!$lines = file($this->setting_txt)) {
            return false;
        }

        foreach ($lines as $line) {
            if (strpos($line, '=') !== false) {
                list($key, $value) = explode('=', $line, 2);
                $key = trim($key);
                $value = trim($value);
                $this->setting_array[$key] = $value;
            }
        }
        $this->setting_array['p2version'] = $_conf['p2version'];

        return true;
    }
    
    /**
     * @access  private
     * @return  boolean
     */
    function saveSettingSrd($setting_array)
    {
        if (false === FileCtl::filePutRename($this->setting_srd, serialize($setting_array))) {
            return false;
        }
        return true;
    }
    
    /**
     * SETTING.TXT ̃p[Xf[^ǂݍ
     *
     * @access  private
     * @return  array
     */
    function readSettingArrayFromSettingSrd()
    {
        global $_conf;
        
        if (!file_exists($this->setting_srd)) {
            //return false;
            return array();
        }

        $setting_array = array();
        if ($cont = file_get_contents($this->setting_srd)) {
            $setting_array = unserialize($cont);
        }
        
        /*
        if ($this->setting_array['p2version'] != $_conf['p2version']) {
            unlink($this->setting_srd);
            unlink($this->setting_txt);
        }
        */
        
        return $setting_array;
    }

    /**
     * @static
     * @access  public 
     * @return  integer|null|s̉H
     */
    function get2chSettingTxtResponseCode($host, $bbs)
    {
        global $_conf;
        
        // SETTING.TXTΉTCgȊOnullԂ
        if (!P2Util::isHost2chs($host) && !P2Util::isHost2chSc($host)) {
            return null;
        }
        
        $subject_url = 'http://' . $host . '/' . $bbs . '/SETTING.TXT';
        $params = array();
        $params['timeout'] = $_conf['fsockopen_timeout'];
        if ($_conf['proxy_use']) {
            $params['proxy_host'] = $_conf['proxy_host'];
            $params['proxy_port'] = $_conf['proxy_port'];
        }
        require_once 'HTTP/Request.php';
        $hr = new HTTP_Request($subject_url, $params);
        $hr->setMethod(HTTP_REQUEST_METHOD_HEAD);
        $hr->sendRequest();
        return $hr->getResponseCode();
    }
    
    /**
     * 2chSETTING.TXT̗LŃzXg̈ړ]mF
     *
     * @return  boolean
     */
    function check2chHostMovedBySettingTxt($new_host, $old_host, $bbs)
    {
        if (!in_array(
                SettingTxt::get2chSettingTxtResponseCode($old_host, $bbs),
                array(200, null), true
            )
            and 200 === SettingTxt::get2chSettingTxtResponseCode($new_host, $bbs)
        ) {
            return true;
        }
        return false;
    }
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
